// Theme definitions for Disco Browser

const themes = {
  disco: {
    name: "🎵 Classic Disco",
    description: "Original disco theme with purple, blue, and pink",
    colors: {
      primary: "#6966bb",
      secondary: "#85cef8",
      accent: "#d8737c",
      warm: "#b75936",
      gold: "#e4c369",
      dark: "#1a1a2e",
      light: "#fafafa",
      background: "linear-gradient(135deg, #6966bb 0%, #85cef8 50%, #d8737c 100%)",
      discoBall: "radial-gradient(circle, rgba(133,206,248,0.4) 0%, rgba(105,102,187,0.2) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(133,206,248,0.2) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(216,115,124,0.2) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(105,102,187,0.2) 0%, transparent 50%)"
    }
  },
  
  neon: {
    name: "💚 Neon Cyber",
    description: "Vibrant neon green and cyan cyberpunk theme",
    colors: {
      primary: "#00ff88",
      secondary: "#00d4ff",
      accent: "#ff00ff",
      warm: "#ff0080",
      gold: "#ffff00",
      dark: "#0a0a0a",
      light: "#ffffff",
      background: "linear-gradient(135deg, #0a0a0a 0%, #001122 50%, #0a0a0a 100%)",
      discoBall: "radial-gradient(circle, rgba(0,255,136,0.5) 0%, rgba(0,212,255,0.3) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(0,255,136,0.3) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(255,0,255,0.3) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(0,212,255,0.3) 0%, transparent 50%)"
    }
  },
  
  sunset: {
    name: "🌅 Sunset Vibes",
    description: "Warm orange, pink, and purple sunset colors",
    colors: {
      primary: "#ff6b6b",
      secondary: "#ffa500",
      accent: "#ff1493",
      warm: "#ff4500",
      gold: "#ffd700",
      dark: "#1a0a1a",
      light: "#fff5e6",
      background: "linear-gradient(135deg, #ff6b6b 0%, #ffa500 50%, #ff1493 100%)",
      discoBall: "radial-gradient(circle, rgba(255,165,0,0.5) 0%, rgba(255,107,107,0.3) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(255,165,0,0.3) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(255,20,147,0.3) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(255,107,107,0.3) 0%, transparent 50%)"
    }
  },
  
  ocean: {
    name: "🌊 Ocean Depths",
    description: "Cool blue and teal ocean-inspired theme",
    colors: {
      primary: "#0066cc",
      secondary: "#00bfff",
      accent: "#00ced1",
      warm: "#1e90ff",
      gold: "#ffd700",
      dark: "#001122",
      light: "#e6f3ff",
      background: "linear-gradient(135deg, #001122 0%, #0066cc 50%, #00bfff 100%)",
      discoBall: "radial-gradient(circle, rgba(0,191,255,0.5) 0%, rgba(0,102,204,0.3) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(0,191,255,0.3) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(0,206,209,0.3) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(30,144,255,0.3) 0%, transparent 50%)"
    }
  },
  
  forest: {
    name: "🌲 Forest Green",
    description: "Natural green and earth tones",
    colors: {
      primary: "#228b22",
      secondary: "#32cd32",
      accent: "#90ee90",
      warm: "#8b4513",
      gold: "#daa520",
      dark: "#0a1a0a",
      light: "#f0fff0",
      background: "linear-gradient(135deg, #0a1a0a 0%, #228b22 50%, #32cd32 100%)",
      discoBall: "radial-gradient(circle, rgba(50,205,50,0.5) 0%, rgba(34,139,34,0.3) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(50,205,50,0.3) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(144,238,144,0.3) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(34,139,34,0.3) 0%, transparent 50%)"
    }
  },
  
  royal: {
    name: "👑 Royal Purple",
    description: "Elegant purple and gold royal theme",
    colors: {
      primary: "#6a0dad",
      secondary: "#9370db",
      accent: "#da70d6",
      warm: "#8b008b",
      gold: "#ffd700",
      dark: "#1a0a2e",
      light: "#f5f0ff",
      background: "linear-gradient(135deg, #1a0a2e 0%, #6a0dad 50%, #9370db 100%)",
      discoBall: "radial-gradient(circle, rgba(147,112,219,0.5) 0%, rgba(106,13,173,0.3) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(147,112,219,0.3) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(218,112,214,0.3) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(106,13,173,0.3) 0%, transparent 50%)"
    }
  },
  
  fire: {
    name: "🔥 Fire & Flame",
    description: "Hot red, orange, and yellow fire theme",
    colors: {
      primary: "#ff4500",
      secondary: "#ff6347",
      accent: "#ffd700",
      warm: "#dc143c",
      gold: "#ffa500",
      dark: "#1a0000",
      light: "#fff5e6",
      background: "linear-gradient(135deg, #1a0000 0%, #ff4500 50%, #ff6347 100%)",
      discoBall: "radial-gradient(circle, rgba(255,165,0,0.6) 0%, rgba(255,69,0,0.4) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(255,69,0,0.4) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(255,215,0,0.4) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(255,99,71,0.4) 0%, transparent 50%)"
    }
  },
  
  space: {
    name: "🚀 Space Explorer",
    description: "Deep space with stars and nebula colors",
    colors: {
      primary: "#4b0082",
      secondary: "#8a2be2",
      accent: "#00bfff",
      warm: "#ff1493",
      gold: "#ffd700",
      dark: "#000000",
      light: "#f0f8ff",
      background: "linear-gradient(135deg, #000000 0%, #1a0033 50%, #4b0082 100%)",
      discoBall: "radial-gradient(circle, rgba(138,43,226,0.5) 0%, rgba(75,0,130,0.3) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(138,43,226,0.3) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(0,191,255,0.3) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(255,20,147,0.3) 0%, transparent 50%)"
    }
  },
  
  cotton: {
    name: "☁️ Cotton Candy",
    description: "Soft pastel pink, blue, and purple",
    colors: {
      primary: "#ffb6c1",
      secondary: "#87ceeb",
      accent: "#dda0dd",
      warm: "#ff69b4",
      gold: "#ffe4e1",
      dark: "#2a1a2a",
      light: "#fff0f5",
      background: "linear-gradient(135deg, #fff0f5 0%, #ffb6c1 50%, #87ceeb 100%)",
      discoBall: "radial-gradient(circle, rgba(255,182,193,0.6) 0%, rgba(135,206,235,0.4) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(255,182,193,0.4) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(221,160,221,0.4) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(135,206,235,0.4) 0%, transparent 50%)"
    }
  },
  
  matrix: {
    name: "💻 Matrix Code",
    description: "Classic Matrix green on black",
    colors: {
      primary: "#00ff41",
      secondary: "#39ff14",
      accent: "#00ff00",
      warm: "#00cc33",
      gold: "#ffff00",
      dark: "#000000",
      light: "#0a0a0a",
      background: "linear-gradient(135deg, #000000 0%, #001100 50%, #000000 100%)",
      discoBall: "radial-gradient(circle, rgba(0,255,65,0.4) 0%, rgba(57,255,20,0.2) 50%, transparent 70%)",
      rays: "radial-gradient(circle at 20% 50%, rgba(0,255,65,0.3) 0%, transparent 50%), radial-gradient(circle at 80% 80%, rgba(57,255,20,0.3) 0%, transparent 50%), radial-gradient(circle at 40% 20%, rgba(0,255,0,0.3) 0%, transparent 50%)"
    }
  }
};

// Theme manager
class ThemeManager {
  constructor() {
    this.currentTheme = 'disco';
  }
  
  async loadTheme() {
    try {
      const result = await chrome.storage.sync.get('selectedTheme');
      this.currentTheme = result.selectedTheme || 'disco';
      this.applyTheme(this.currentTheme);
    } catch (error) {
      console.error('Error loading theme:', error);
      this.applyTheme('disco');
    }
  }
  
  async saveTheme(themeName) {
    try {
      await chrome.storage.sync.set({ selectedTheme: themeName });
      this.currentTheme = themeName;
      this.applyTheme(themeName);
    } catch (error) {
      console.error('Error saving theme:', error);
    }
  }
  
  applyTheme(themeName) {
    const theme = themes[themeName] || themes.disco;
    const root = document.documentElement;
    
    // Apply CSS variables
    root.style.setProperty('--disco-primary', theme.colors.primary);
    root.style.setProperty('--disco-secondary', theme.colors.secondary);
    root.style.setProperty('--disco-accent', theme.colors.accent);
    root.style.setProperty('--disco-warm', theme.colors.warm);
    root.style.setProperty('--disco-gold', theme.colors.gold);
    root.style.setProperty('--disco-dark', theme.colors.dark);
    root.style.setProperty('--disco-light', theme.colors.light);
    
    // Apply background gradients
    const container = document.querySelector('.disco-container');
    if (container) {
      container.style.background = theme.colors.background;
    }
    
    // Apply disco ball
    const discoBall = document.querySelector('.disco-ball');
    if (discoBall) {
      discoBall.style.background = theme.colors.discoBall;
    }
    
    // Apply light rays
    const lightRays = document.querySelector('.light-rays');
    if (lightRays) {
      lightRays.style.background = theme.colors.rays;
    }
    
    // Update all gradient backgrounds
    this.updateGradients(theme);
  }
  
  updateGradients(theme) {
    // Update all elements with gradient backgrounds
    const gradientElements = document.querySelectorAll('.disco-logo, .count-badge, .disco-btn.primary, .domain-tag');
    gradientElements.forEach(el => {
      if (el.classList.contains('disco-logo') || el.classList.contains('count-badge') || el.classList.contains('domain-tag')) {
        el.style.background = `linear-gradient(135deg, ${theme.colors.primary} 0%, ${theme.colors.accent} 100%)`;
      } else if (el.classList.contains('disco-btn') && el.classList.contains('primary')) {
        el.style.background = `linear-gradient(135deg, ${theme.colors.primary} 0%, ${theme.colors.secondary} 100%)`;
      }
    });
  }
  
  getThemes() {
    return themes;
  }
  
  getCurrentTheme() {
    return this.currentTheme;
  }
}

// Export for use in other files
if (typeof window !== 'undefined') {
  window.ThemeManager = ThemeManager;
  window.themes = themes;
}

