// Options page script

document.addEventListener('DOMContentLoaded', async () => {
  await loadSettings();
  
  document.getElementById('saveBtn').addEventListener('click', saveSettings);
  document.getElementById('cancelBtn').addEventListener('click', () => {
    window.close();
  });
  document.getElementById('clearData').addEventListener('click', clearAllData);
});

// Load saved settings
async function loadSettings() {
  try {
    const result = await chrome.storage.sync.get([
      'aiProvider',
      'apiKey',
      'historyDays',
      'autoAnalyze',
      'storeHistory',
      'shareData',
      'selectedTheme'
    ]);
    
    document.getElementById('aiProvider').value = result.aiProvider || 'mock';
    document.getElementById('apiKey').value = result.apiKey || '';
    document.getElementById('historyDays').value = result.historyDays || 7;
    document.getElementById('autoAnalyze').checked = result.autoAnalyze !== false;
    document.getElementById('storeHistory').checked = result.storeHistory !== false;
    document.getElementById('shareData').checked = result.shareData || false;
    document.getElementById('themeSelect').value = result.selectedTheme || 'disco';
  } catch (error) {
    console.error('Error loading settings:', error);
  }
}

// Save settings
async function saveSettings() {
  try {
    const settings = {
      aiProvider: document.getElementById('aiProvider').value,
      apiKey: document.getElementById('apiKey').value,
      historyDays: parseInt(document.getElementById('historyDays').value),
      autoAnalyze: document.getElementById('autoAnalyze').checked,
      storeHistory: document.getElementById('storeHistory').checked,
      shareData: document.getElementById('shareData').checked,
      selectedTheme: document.getElementById('themeSelect').value
    };
    
    await chrome.storage.sync.set(settings);
    
    showSuccessMessage('Settings saved successfully!');
  } catch (error) {
    alert('Error saving settings: ' + error.message);
  }
}

// Clear all stored data
async function clearAllData() {
  if (!confirm('Are you sure you want to clear all stored data? This cannot be undone.')) {
    return;
  }
  
  try {
    await chrome.storage.local.clear();
    await chrome.storage.sync.clear();
    showSuccessMessage('All data cleared successfully!');
  } catch (error) {
    alert('Error clearing data: ' + error.message);
  }
}

// Show success message
function showSuccessMessage(message) {
  const container = document.querySelector('.container');
  let successDiv = document.getElementById('successMessage');
  
  if (!successDiv) {
    successDiv = document.createElement('div');
    successDiv.id = 'successMessage';
    successDiv.className = 'success-message';
    container.insertBefore(successDiv, container.firstChild.nextSibling);
  }
  
  successDiv.textContent = message;
  successDiv.classList.add('show');
  
  setTimeout(() => {
    successDiv.classList.remove('show');
  }, 3000);
}

