# Disco Browser - Chrome Extension

Disco Browser is a Chrome extension featuring AI-powered browsing analysis and GenTabs functionality that creates personalized web applications based on your browsing patterns.

## Features

- **Tab Analysis**: Analyze your open tabs and browsing patterns
- **History Analysis**: Understand your browsing habits over time
- **GenTabs**: Generate personalized web applications based on your browsing data
- **AI Integration**: Support for Google Gemini, OpenAI, or mock mode for testing
- **Privacy-Focused**: All data stored locally, optional API key configuration

## Installation

### Step 1: Prepare the Extension

1. Clone or download this repository
2. Ensure all files are in the same directory

### Step 2: Create Icons

You need to create icon files for the extension. Create three PNG files:
- `icons/icon16.png` (16x16 pixels)
- `icons/icon48.png` (48x48 pixels)
- `icons/icon128.png` (128x128 pixels)

You can use any image editor or online tool to create these icons. A simple disco ball or music note icon would be appropriate.

**Quick Icon Creation:**
- Use an online icon generator like [favicon.io](https://favicon.io/)
- Or create simple colored squares with text "🎵" or "Disco"
- Save them in the `icons/` folder with the correct names

### Step 3: Load the Extension in Chrome

1. Open Chrome and navigate to `chrome://extensions/`
2. Enable **Developer mode** (toggle in the top right)
3. Click **Load unpacked**
4. Select the folder containing this extension
5. The extension should now appear in your extensions list

### Step 4: Configure AI (Optional)

1. Click the extension icon in your Chrome toolbar
2. Click **Settings**
3. Choose your AI provider (Gemini, OpenAI, or Mock for testing)
4. Enter your API key if using a real AI service
5. Click **Save Settings**

## Usage

### Analyzing Browsing Patterns

1. Click the extension icon
2. Click **Analyze** to see your browsing patterns
3. View top domains, tab statistics, and history insights

### Generating Apps with GenTabs

1. Click the extension icon
2. Click **Generate App** in the GenTabs section
3. Enter a description of what you'd like to create
4. Click **Create**
5. The extension will generate a personalized app based on your browsing data

## Project Structure

```
.
├── manifest.json          # Extension manifest
├── background.js          # Service worker for tab/history analysis
├── popup.html             # Extension popup UI
├── popup.js               # Popup functionality
├── popup.css              # Popup styles
├── options.html           # Settings page
├── options.js             # Settings functionality
├── options.css            # Settings styles
├── content.js             # Content script for page analysis
├── ai-service.js          # AI integration service
├── icons/                 # Extension icons (you need to create these)
│   ├── icon16.png
│   ├── icon48.png
│   └── icon128.png
└── README.md              # This file
```

## AI Integration

The extension supports multiple AI providers:

### Mock Mode (Default)
- Works out of the box for testing
- Generates mock apps based on browsing patterns
- No API key required

### Google Gemini
1. Get your API key from [Google AI Studio](https://makersuite.google.com/app/apikey)
2. Set provider to "Google Gemini" in settings
3. Enter your API key

### OpenAI
1. Get your API key from [OpenAI Platform](https://platform.openai.com/api-keys)
2. Set provider to "OpenAI" in settings
3. Enter your API key

**Note:** The AI integration code is structured but requires implementation of the actual API calls in `ai-service.js`. The mock mode works fully for demonstration purposes.

## Permissions

The extension requires the following permissions:
- `tabs`: To analyze open tabs
- `history`: To analyze browsing history
- `storage`: To save settings and analysis data
- `activeTab`: To interact with the current tab

## Development

### Making Changes

1. Edit the relevant files
2. Go to `chrome://extensions/`
3. Click the refresh icon on the extension card
4. Test your changes

### Debugging

- **Popup**: Right-click the extension icon → Inspect popup
- **Background**: Go to `chrome://extensions/` → Click "service worker" link
- **Options**: Right-click the options page → Inspect

## Privacy

- All data is stored locally in your browser
- API keys are stored in Chrome's sync storage (encrypted)
- No data is sent to external servers unless you configure an AI provider
- You can clear all data from the settings page

## Troubleshooting

### Extension won't load
- Check that `manifest.json` is valid JSON
- Ensure all referenced files exist
- Check the browser console for errors

### Icons not showing
- Verify icon files exist in the `icons/` folder
- Check file names match exactly (case-sensitive)
- Ensure icons are valid PNG files

### AI generation not working
- Check your API key is correct
- Verify you have internet connection
- Check browser console for API errors
- Try Mock mode first to test functionality

## Future Enhancements

- [ ] Full Gemini API integration
- [ ] Full OpenAI API integration
- [ ] More sophisticated browsing pattern analysis
- [ ] Export/import settings
- [ ] Custom app templates
- [ ] Real-time tab monitoring
- [ ] Advanced filtering options

## License

This is a clone/educational project. Use at your own discretion.

## Credits

Inspired by Google's experimental Disco browser with GenTabs functionality.

