# Disco Browser - Installation & Features Guide

## 🎵 Overview

Disco Browser is a Chrome extension that brings AI-powered browsing analysis and personalized web application generation to your browser. This extension analyzes your browsing patterns and creates customized experiences based on your web activity.

---

## ✨ Features

### 🔍 **Tab Analysis**
- **Real-time Tab Monitoring**: View all your open tabs in a beautiful full-screen interface
- **Tab Statistics**: See how many tabs you have open and across how many unique domains
- **Quick Access**: Click any tab to navigate to it instantly
- **Visual Tab List**: See favicons and titles for easy identification

### 📊 **Browsing Pattern Analysis**
- **History Analysis**: Analyze your browsing history over customizable time periods (default: 7 days)
- **Top Domains**: Discover your most frequently visited websites
- **Pattern Recognition**: Identify your browsing habits and preferences
- **Insights Dashboard**: Visual cards showing your browsing statistics

### 🎨 **GenTabs - AI-Powered App Generation**
- **Personalized Apps**: Generate custom web applications based on your browsing data
- **Natural Language Input**: Describe what you want to create in plain English
- **Context-Aware**: Uses your browsing history and open tabs to create relevant apps
- **Multiple AI Providers**: Support for Google Gemini, OpenAI, or Mock mode for testing

### 🎭 **Full-Screen Disco Interface**
- **Immersive Experience**: Beautiful full-screen interface with disco-themed design
- **Animated Background**: Rotating disco ball with colorful light rays
- **Modern UI**: Glassmorphism effects and smooth animations
- **Three-Panel Layout**: Organized tabs, GenTabs, and insights panels

### ⚙️ **Customizable Settings**
- **AI Provider Selection**: Choose between Gemini, OpenAI, or Mock mode
- **Privacy Controls**: Control data storage and sharing preferences
- **Analysis Period**: Customize how far back to analyze browsing history
- **Auto-Analysis**: Enable automatic periodic analysis of browsing patterns

### 🔒 **Privacy-Focused**
- **Local Storage**: All data stored locally in your browser
- **No Tracking**: Your browsing data never leaves your device
- **Optional AI**: Use mock mode without any API keys
- **Data Control**: Clear all stored data anytime from settings

---

## 📦 Installation Instructions

### Prerequisites
- Google Chrome browser (latest version recommended)
- Internet connection (for AI features, optional)

### Step-by-Step Installation

#### Step 1: Prepare the Extension Files

1. **Download or Clone** the extension files to your computer
2. **Ensure all files are present** in the extension folder:
   - `manifest.json`
   - `disco.html`, `disco.css`, `disco.js`
   - `background.js`
   - `popup.html`, `popup.css`, `popup.js` (legacy popup)
   - `options.html`, `options.css`, `options.js`
   - `ai-service.js`
   - `content.js`
   - `icons/` folder with icon files

#### Step 2: Create Extension Icons

The extension requires icon files. You have two options:

**Option A: Use the Icon Generator**
1. Open `create-icons.html` in your Chrome browser
2. Click "Download" for each icon size (16px, 48px, 128px)
3. Save them in the `icons/` folder as:
   - `icons/icon16.png`
   - `icons/icon48.png`
   - `icons/icon128.png`

**Option B: Create Custom Icons**
- Use any image editor to create 16x16, 48x48, and 128x128 pixel PNG icons
- Save them in the `icons/` folder with the correct names

#### Step 3: Enable Developer Mode in Chrome

1. **Open Chrome** and navigate to the extensions page:
   - Type `chrome://extensions/` in the address bar, OR
   - Go to Menu (⋮) → **Extensions** → **Manage extensions**

2. **Enable Developer Mode**:
   - Toggle the **"Developer mode"** switch in the top-right corner
   - The switch should turn blue/active

#### Step 4: Load the Extension

1. **Click "Load unpacked"** button (appears after enabling Developer mode)
2. **Navigate** to the folder containing your extension files
3. **Select the folder** and click "Select Folder" (or "Open" on Mac)
4. The extension should now appear in your extensions list

#### Step 5: Verify Installation

1. **Check the extension icon** appears in your Chrome toolbar
2. **Click the extension icon** to open the full-screen Disco interface
3. If you see the disco-themed interface, installation was successful!

---

## 🚀 Quick Start

### First Launch

1. **Click the extension icon** in your Chrome toolbar
2. The full-screen Disco interface will open
3. **Explore the interface**:
   - Left panel: Your open tabs
   - Center panel: GenTabs for creating apps
   - Right panel: Browsing insights

### Basic Usage

#### Analyze Your Browsing Patterns
1. Click **"📊 Analyze Browsing"** button
2. View your top domains and browsing statistics
3. Insights appear in the right panel

#### Generate a Personalized App
1. Type a description in the GenTabs text area
   - Example: "Create a news aggregator from my favorite sites"
2. Click **"✨ Generate App"**
3. Your personalized app will appear below

#### Configure AI (Optional)
1. Click **"⚙️ Settings"** in the footer
2. Choose your AI provider:
   - **Mock**: Works without API keys (for testing)
   - **Google Gemini**: Requires API key from [Google AI Studio](https://makersuite.google.com/app/apikey)
   - **OpenAI**: Requires API key from [OpenAI Platform](https://platform.openai.com/api-keys)
3. Enter your API key if using a real AI service
4. Click **"Save Settings"**

---

## 🎯 Usage Tips

### Keyboard Shortcuts
- **ESC**: Close the Disco interface
- **Cmd/Ctrl + Enter**: Generate app from prompt

### Best Practices
- **Start with Mock mode** to test functionality without API keys
- **Analyze regularly** to keep insights up to date
- **Use descriptive prompts** for better GenTabs results
- **Clear data periodically** if privacy is a concern

---

## 🔧 Troubleshooting

### Extension Won't Load
- ✅ Check that `manifest.json` is valid JSON
- ✅ Ensure all referenced files exist
- ✅ Verify icon files are in the `icons/` folder
- ✅ Check Chrome's error console: `chrome://extensions/` → Click "Errors"

### Icons Not Showing
- ✅ Verify icon files exist: `icon16.png`, `icon48.png`, `icon128.png`
- ✅ Check file names are exactly correct (case-sensitive)
- ✅ Ensure icons are valid PNG files

### Full-Screen Interface Not Opening
- ✅ Check that `disco.html` exists in the extension folder
- ✅ Verify `background.js` is loaded (check service worker)
- ✅ Try reloading the extension: `chrome://extensions/` → Click reload icon

### AI Generation Not Working
- ✅ Check your API key is correct (if using real AI)
- ✅ Verify internet connection
- ✅ Try Mock mode first to test functionality
- ✅ Check browser console for error messages

### Analysis Not Working
- ✅ Ensure you have browsing history (visit some websites first)
- ✅ Check that tabs permission is granted
- ✅ Verify history permission is enabled

---

## 📋 Permissions Explained

The extension requires these permissions:

- **`tabs`**: To analyze and display your open tabs
- **`history`**: To analyze your browsing history
- **`storage`**: To save settings and analysis data locally
- **`activeTab`**: To interact with the current tab
- **`windows`**: To create the full-screen interface window

All data stays on your device - nothing is sent to external servers unless you configure an AI provider.

---

## 🆘 Support

### Common Issues

**Q: Can I use this without API keys?**  
A: Yes! Mock mode works fully without any API keys for testing.

**Q: Is my data private?**  
A: Yes! All data is stored locally. Only if you configure an AI provider will data be sent to that service.

**Q: How do I uninstall?**  
A: Go to `chrome://extensions/`, find "Disco Browser", and click "Remove".

**Q: Can I customize the colors?**  
A: Yes! Edit `disco.css` and modify the CSS variables in the `:root` section.

**Q: Does this work in other browsers?**  
A: Currently designed for Chrome. Firefox and Edge may work with modifications.

---

## 📝 Version Information

- **Version**: 1.0.0
- **Manifest Version**: 3
- **Chrome Version**: Latest recommended

---

## 🎉 You're All Set!

Enjoy your new AI-powered browsing experience with Disco Browser! 

For more information, check the `README.md` file or explore the extension settings.

---

**Note**: This is an educational/clone project inspired by Google's experimental Disco browser. Use at your own discretion.

